(function ($) {
    'use strict';

    $(function () {
        // Confirm purge
        $('form[action*="ppwix_cf7_purge"]').on('submit', function (e) {
            if (!confirm('Are you sure you want to permanently delete all exported entries for this form?')) {
                e.preventDefault();
            }
        });

        // Show success message if redirected with ?purged=1
        const params = new URLSearchParams(window.location.search);
        if (params.has('purged') && params.get('purged') === '1') {
            $('<div class="notice notice-success is-dismissible"><p>Exported entries purged successfully.</p></div>')
                .insertAfter('h1.wp-heading-inline');
        }
    });
})(jQuery);
