<?php
if (!defined('ABSPATH')) exit;

class PPwix_CF7_Logger_Admin {

    public function __construct() {
        add_action('admin_menu', [$this, 'add_menu']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_assets']);
        add_action('admin_post_ppwix_cf7_export', [$this, 'handle_export']);
        add_action('admin_post_ppwix_cf7_purge', [$this, 'handle_purge']);
    }

    public function add_menu() {
        add_menu_page(
            __('CF7 Logs', 'ppwix-cf7-logger'),
            __('CF7 Logs', 'ppwix-cf7-logger'),
            'manage_options',
            'ppwix-cf7-logs',
            [$this, 'render_admin_page'],
            'dashicons-feedback',
            26
        );
    }

    public function enqueue_assets() {
        wp_enqueue_style('ppwix-cf7-logger-admin', plugins_url('../assets/admin.css', __FILE__), [], PPWIX_CF7_LOGGER_VERSION);
        wp_enqueue_script('ppwix-cf7-logger-admin', plugins_url('../assets/admin.js', __FILE__), ['jquery'], PPWIX_CF7_LOGGER_VERSION, true);
    }

    public function render_admin_page() {
        echo '<div class="wrap"><h1>PPwix CF7 Logs</h1>';

        if (!PPwix_CF7_Logger_DB::check_table_exists()) {
            echo '<div class="notice notice-error"><p>Database table not found. Please deactivate and reactivate the plugin to recreate it.</p></div>';
            return;
        }

        if (!class_exists('WPCF7_ContactForm')) {
            echo '<div class="notice notice-error"><p>Contact Form 7 not detected. Please activate it to view logs.</p></div>';
            return;
        }

        $forms = WPCF7_ContactForm::find();
        if (empty($forms)) {
            echo '<p>No Contact Form 7 forms detected.</p></div>';
            return;
        }

        // Tabs
        echo '<h2 class="nav-tab-wrapper">';
        foreach ($forms as $form) {
            $active = (isset($_GET['form_id']) && $_GET['form_id'] == $form->id()) ? ' nav-tab-active' : '';
            echo '<a href="?page=ppwix-cf7-logs&form_id=' . esc_attr($form->id()) . '" class="nav-tab' . $active . '">' . esc_html($form->title()) . '</a>';
        }
        echo '</h2>';

        if (isset($_GET['form_id'])) {
            $this->render_form_entries(intval($_GET['form_id']));
        }

        echo '</div>';
    }

    private function render_form_entries($form_id) {
        global $wpdb;
        $table = PPwix_CF7_Logger_DB::table_name();

        // Handle filters
        $start = isset($_GET['start']) ? sanitize_text_field($_GET['start']) : '';
        $end   = isset($_GET['end']) ? sanitize_text_field($_GET['end']) : '';
        $search = isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '';

        $where = "WHERE form_id = %d";
        $params = [$form_id];

        if ($start) {
            $where .= " AND submission_date >= %s";
            $params[] = $start . " 00:00:00";
        }
        if ($end) {
            $where .= " AND submission_date <= %s";
            $params[] = $end . " 23:59:59";
        }
        if ($search) {
            $where .= " AND submitted_data LIKE %s";
            $params[] = '%' . $wpdb->esc_like($search) . '%';
        }

        $query = $wpdb->prepare("SELECT * FROM $table $where ORDER BY submission_date DESC", $params);
        $entries = $wpdb->get_results($query);

        // Filters form
        echo '<form method="get" class="ppwix-filters">';
        echo '<input type="hidden" name="page" value="ppwix-cf7-logs">';
        echo '<input type="hidden" name="form_id" value="' . esc_attr($form_id) . '">';
        echo '<label>Start Date: <input type="date" name="start" value="' . esc_attr($start) . '"></label> ';
        echo '<label>End Date: <input type="date" name="end" value="' . esc_attr($end) . '"></label> ';
        echo '<label>Search: <input type="text" name="s" value="' . esc_attr($search) . '" placeholder="Keyword..."></label> ';
        echo '<button class="button">Filter</button>';
        echo '</form>';

        // Export & Purge
        echo '<form method="post" action="' . admin_url('admin-post.php') . '" style="margin-top:10px;">';
        echo '<input type="hidden" name="action" value="ppwix_cf7_export">';
        echo '<input type="hidden" name="form_id" value="' . esc_attr($form_id) . '">';
        echo '<input type="hidden" name="start" value="' . esc_attr($start) . '">';
        echo '<input type="hidden" name="end" value="' . esc_attr($end) . '">';
        echo '<input type="hidden" name="s" value="' . esc_attr($search) . '">';
        submit_button('Export Filtered Entries (CSV)', 'primary', 'submit', false);
        echo '</form>';

        echo '<form method="post" action="' . admin_url('admin-post.php') . '" style="margin-top:5px;">';
        echo '<input type="hidden" name="action" value="ppwix_cf7_purge">';
        echo '<input type="hidden" name="form_id" value="' . esc_attr($form_id) . '">';
        submit_button('Purge Exported Entries', 'delete', 'submit', false);
        echo '</form>';

        echo '<table class="widefat fixed striped" style="margin-top:20px;">';
        echo '<thead><tr><th>ID</th><th>Date</th><th>Data</th><th>Status</th></tr></thead><tbody>';

        if ($entries) {
            foreach ($entries as $e) {
                echo '<tr>';
                echo '<td>' . intval($e->id) . '</td>';
                echo '<td>' . esc_html($e->submission_date) . '</td>';
                echo '<td><pre>' . esc_html(print_r(json_decode($e->submitted_data, true), true)) . '</pre></td>';
                echo '<td>' . esc_html($e->status) . '</td>';
                echo '</tr>';
            }
        } else {
            echo '<tr><td colspan="4">No entries found.</td></tr>';
        }

        echo '</tbody></table>';
    }

    public function handle_export() {
        global $wpdb;
        if (!current_user_can('manage_options')) wp_die('Unauthorized');

        $form_id = intval($_POST['form_id']);
        $start = sanitize_text_field($_POST['start']);
        $end = sanitize_text_field($_POST['end']);
        $search = sanitize_text_field($_POST['s']);

        $table = PPwix_CF7_Logger_DB::table_name();
        $where = "WHERE form_id = %d";
        $p
