<?php
if (!defined('ABSPATH')) exit;

class PPwix_CF7_Logger_DB {

    public static function table_name() {
        global $wpdb;
        return $wpdb->prefix . 'ppwix_cf7_logs';
    }

    public static function create_table() {
        global $wpdb;
        $table_name = self::table_name();
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE IF NOT EXISTS $table_name (
            id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            form_id BIGINT(20),
            form_title VARCHAR(255),
            submitted_data LONGTEXT,
            submission_date DATETIME DEFAULT CURRENT_TIMESTAMP,
            status ENUM('not_exported','exported') DEFAULT 'not_exported'
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }

    public static function check_table_exists() {
        global $wpdb;
        $table_name = self::table_name();
        return ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") == $table_name);
    }
}
