<?php
/**
 * Plugin Name: PPwix CF7 Form Logger
 * Description: Logs Contact Form 7 submissions, grouped by form, for export and management.
 * Version: 1.0.0
 * Author: PPwix Website Services
 * Text Domain: ppwix-cf7-logger
 */

if (!defined('ABSPATH')) exit;

define('PPWIX_CF7_LOGGER_VERSION', '1.0.0');
define('PPWIX_CF7_LOGGER_DIR', plugin_dir_path(__FILE__));

// Load dependencies
require_once PPWIX_CF7_LOGGER_DIR . 'includes/class-ppwix-cf7-logger-db.php';
require_once PPWIX_CF7_LOGGER_DIR . 'includes/class-ppwix-cf7-logger-admin.php';

/**
 * Check CF7 dependency on activation
 */
register_activation_hook(__FILE__, 'ppwix_cf7_logger_activation_check');
function ppwix_cf7_logger_activation_check() {
    if (!is_plugin_active('contact-form-7/wp-contact-form-7.php')) {
        deactivate_plugins(plugin_basename(__FILE__));
        wp_die(
            __('PPwix CF7 Form Logger requires Contact Form 7 to be installed and active. Please install and activate Contact Form 7 first.', 'ppwix-cf7-logger'),
            __('Plugin dependency check', 'ppwix-cf7-logger'),
            ['back_link' => true]
        );
    }
    PPwix_CF7_Logger_DB::create_table();
}

/**
 * Admin notice if CF7 missing after activation
 */
add_action('admin_init', function() {
    if (!is_plugin_active('contact-form-7/wp-contact-form-7.php')) {
        add_action('admin_notices', function() {
            echo '<div class="notice notice-error"><p><strong>PPwix CF7 Form Logger</strong> requires Contact Form 7 to be active. Please activate it to continue using this plugin.</p></div>';
        });
    }
});

/**
 * Log submissions
 */
add_action('wpcf7_before_send_mail', 'ppwix_cf7_logger_log_submission');
function ppwix_cf7_logger_log_submission($contact_form) {
    global $wpdb;

    if (!class_exists('WPCF7_Submission')) return;
    $submission = WPCF7_Submission::get_instance();
    if (!$submission) return;

    $form_id = $contact_form->id();
    $form_title = $contact_form->title();
    $data = $submission->get_posted_data();
    $json_data = wp_json_encode($data);

    $wpdb->insert(
        $wpdb->prefix . 'ppwix_cf7_logs',
        [
            'form_id' => $form_id,
            'form_title' => $form_title,
            'submitted_data' => $json_data,
            'status' => 'not_exported'
        ]
    );
}

/**
 * Initialize Admin
 */
if (is_admin()) {
    new PPwix_CF7_Logger_Admin();
}
